require 'rubygems'
require 'watir-webdriver'
require 'page-object'
require 'rspec'
require_relative '../../spec/rspec_helper'
require_relative '../../../../test/watir-ruby/common/loginLogout'
require_relative '../roa'
require_relative '../../pages/landing_appointments'
require_relative '../launchpad'
require_relative '../notifications'
require_relative '../../pages/community_care/community_care_service'
require_relative 'landing_page_cc'
require_relative '../eula'
require_relative '../../common/common'
require_relative '../../helper/modal'
require_relative '../../pages/landing'
require_relative '../../pages/feedback'
require_relative '../appointments/request_appointment_detail'


class CommunityCare_PageObject
  include PageObject

  def initialize(driver)
    @driver = driver
  end

  def loginLogout
    LoginLogout.new(@driver)
  end

  def appointment
    Appointment.new(@driver)
  end

  def login
    Login.new(@driver)
  end

  def landing
    Landing.new(@driver)
  end

  def common
    Common.new(@driver)
  end

  def userMenu
    UserMenuOption.new(@driver)
  end

  def eula
    Eula.new(@driver)
  end

  def listView
    ListView.new(@driver)
  end

  def errorValidation
    ErrorValidation.new(@driver)
  end

  def modal
    Modal.new(@driver)
  end


  def detailsView
    RequestAppointmentDetail.new(@driver)
  end

  def traditionalAppt
    TraditionalAppt.new(@driver)
  end

  def waitUtility
    WaitUtility.new(@driver)
  end

  def sessionSetup
    SessionSetup.new(@driver)
  end
  def modal
    Modal.new(@driver)
  end

  def roa
    Roa.new(@driver)
  end

  def landingAppointments
    LandingAppointments.new(@driver)
  end

  def launchpad
    Launchpad.new(@driver)
  end

  def notificationSettings
    Notification_Settings.new(@driver)
  end

  def communityCare
    CommunityCare.new(@driver)
  end

  def landingCC
    LandingCC.new(@driver)
  end

  def feedback
    Feedback.new(@driver)
  end

end